<?php

namespace UtillzCore\Inc\Src\Notification\Notifications;

class Welcome extends \UtillzCore\Inc\Src\Notification\Base {

    /*
     * general
     *
     */
    public function get_id() {
        return 'welcome';
    }

    public function get_name() {
        return esc_html__('Welcome aboard!', 'utillz-core');
    }

    /*
     * email
     *
     */
    public function get_email_subject() {
        return esc_html__( 'Welcome aboard', 'utillz-core' );
    }

    public function get_email_template() {
        return esc_html__( "Hello {user_display_name},\r\n\r\nThank you for joining us!", 'utillz-core' );
    }

    /*
     * email admin
     *
     */
    public function get_email_admin_subject() {
        return esc_html__( 'New user', 'utillz-core' );
    }

    public function get_email_admin_template() {
        return esc_html__( "Hello,\r\n\r\nNew user has joined the family!", 'utillz-core' );
    }

    /*
     * site
     *
     */
    public function get_site_icon() {
        return [
            'set' => 'material-icons',
            'icon' => 'favorite',
        ];
    }

    public function get_site_message() {
        return esc_html__( 'Welcome aboard {user_display_name}!', 'utillz-core' );
    }

    public function get_site_url() {
        return null;
    }

}
